/*******************************************************************************
 * CS220: Digital Circuits Lab
 * Computer Science Department
 * University of Crete
 * 
 * Date: 2024/03/08
 * Author: CS220 Instructors
 * Filename: lab0_tb.sv
 * Description: A simple testbench that generates clock and reset
 *
 ******************************************************************************/

`timescale 1ns / 1ns

// CLK 10 ns -> 100 MHz
`define CLK_PERIOD 10
`define SIM_CYCLES 1000

module lab0_tb;

logic clk;
logic rst;

always #(`CLK_PERIOD/2) clk = ~clk;

logic dip = 1;
logic [7:0] led;

lab0_top dut (
  .clk(clk),
  .rst(rst),

  .i_dip(dip),
  .o_led(led)
);

// clk and reset
initial begin
  $dumpfile("tb_waves.vcd");
  $dumpvars;

  clk = 0;
  rst = 1;
  @(posedge clk);
  @(posedge clk);
  @(posedge clk);
  #1;
  rst = 0;
  @(posedge clk);


  repeat (`SIM_CYCLES) @(posedge clk);
  #1;
  $finish;
end

endmodule
